/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.SoilStateGenerator;
import com.ferreusveritas.dynamictrees.block.branch.BasicRootsBlock;
import com.ferreusveritas.dynamictrees.block.rooty.AerialRootsSoilProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;

public final class AerialRootsSoilGenerator
extends SoilStateGenerator {
    public static final Generator.DependencyKey<Block> ROOTS = new Generator.DependencyKey("roots");

    @Override
    public void generate(DTBlockStateProvider provider, SoilProperties input, Generator.Dependencies dependencies) {
        VariantBlockStateBuilder builder = provider.getVariantBuilder((Block)dependencies.get(SOIL));
        for (int i = 1; i <= 8; ++i) {
            builder = (VariantBlockStateBuilder)builder.partialState().with((Property)BasicRootsBlock.RADIUS, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)this.soilModelBuilder(provider, input, i, provider.blockTexture((Block)dependencies.get(SOIL)).m_135815_(), (Block)dependencies.get(PRIMITIVE_SOIL), dependencies.get(ROOTS))).addModel();
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(SoilProperties input) {
        AerialRootsSoilProperties aerialInput = (AerialRootsSoilProperties)input;
        return new Generator.Dependencies().append(SOIL, input.getBlock()).append(PRIMITIVE_SOIL, input.getPrimitiveSoilBlockOptional()).append(ROOTS, aerialInput.getFamily().getPrimitiveRoots());
    }

    private BlockModelBuilder soilModelBuilder(BlockStateProvider provider, SoilProperties input, int radius, String name, Block primitiveBlock, Block roots) {
        AerialRootsSoilProperties aerialInput = (AerialRootsSoilProperties)input;
        ResourceLocation side = aerialInput.getFamily().getTexturePath("branch").orElse(provider.blockTexture(primitiveBlock));
        ResourceLocation top = aerialInput.getFamily().getTexturePath("branch_top").orElse(ResourceLocationUtils.suffix(provider.blockTexture(primitiveBlock), "_top"));
        ResourceLocation roots_side = aerialInput.getFamily().getTexturePath("roots_side").orElse(ResourceLocationUtils.suffix(provider.blockTexture(roots), "_side"));
        ResourceLocation roots_top = aerialInput.getFamily().getTexturePath("roots_side").orElse(ResourceLocationUtils.suffix(provider.blockTexture(roots), "_top"));
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_radius" + radius, DynamicTrees.location("block/smartmodel/rooty/aerial_roots_radius" + radius))).texture("side", side)).texture("end", top)).texture("overlay", roots_side)).texture("overlay_end", roots_top);
        input.getTexturePath("roots").ifPresent(r -> builder.texture("roots", r));
        return builder;
    }
}

